﻿// 模板规则
//   1. 用 "//<snippet>" 标记来标记代码段。第一处标记用于确定代码段的开头。
//      第二处标记用于确定结尾。建议(但不要求)添加 BEGIN 和
//      END 后缀，以便获得更佳的可读性，例如 "//<snippet> - BEGIN", "//<snippet> - END"。
//      如果代码段只有一行，则可以省略第二个标记(例如，请参阅 ClrNamespaceFooter 标记)。
//
//   2. 代码段标记应该位于代码段上面(下面)单独的行上，或者位于第一个 
//      (最后一个)代码段行的末尾。从标记到行末尾的文本将被删除。
//
//   3. 以下区分大小写的字是保留字。它们将在示例数据代码生成过程中被示例数据名称(类型名称、
//      属性名称等)所替代。
//          CLR_NAMESPACE
//          APPLICATION_NAMESPACE
//          SAMPLE_DATA_URI
//          COMPOSITE_TYPE
//          PROPERTY_NAME
//          PROPERTY_TYPE
//          PROPERTY_VALUE
//          COLLECTION_TYPE
//          ITEM_TYPE
//
//   4. 区分大小写的代码段标记为
//          ClrNamespaceHeader
//          ClrNamespaceFooter
//          CompositeTypeHeader
//          CompositeTypeFooter
//          RootTypeConstructor
//          GetSetProperty
//          GetProperty
//          CollectionType
///////////////////////////////////////////////////
namespace CLR_NAMESPACE //ClrNamespaceHeader - BEGIN
{
	using System; 
	using System.ComponentModel;

// 若要在生产应用程序中显著减小示例数据涉及面，则可以设置
// DISABLE_SAMPLE_DATA 条件编译常量并在运行时禁用示例数据。
#if DISABLE_SAMPLE_DATA
	internal class COMPOSITE_TYPE { }
#else  //ClrNamespaceHeader - END

	public class COMPOSITE_TYPE : INotifyPropertyChanged //CompositeTypeHeader - BEGIN
	{
		public event PropertyChangedEventHandler PropertyChanged;

		protected virtual void OnPropertyChanged(string propertyName)
		{
			if (this.PropertyChanged != null)
			{
				this.PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
			}
		} //CompositeTypeHeader - END

		public COMPOSITE_TYPE() //RootTypeConstructor - BEGIN
		{
			try
			{
				Uri resourceUri = new Uri("SAMPLE_DATA_URI", UriKind.RelativeOrAbsolute);
				APPLICATION_NAMESPACE.Application.LoadComponent(this, resourceUri);
			}
			catch
			{
			}
		} //RootTypeConstructor - END

		private PROPERTY_TYPE _PROPERTY_NAME = PROPERTY_VALUE;  //GetSetProperty - BEGIN

		public PROPERTY_TYPE PROPERTY_NAME
		{
			get
			{
				return this._PROPERTY_NAME;
			}

			set
			{
				if (this._PROPERTY_NAME != value)
				{
					this._PROPERTY_NAME = value;
					this.OnPropertyChanged("PROPERTY_NAME");
				}
			}
		}  //GetSetProperty - END

		private PROPERTY_TYPE _PROPERTY_NAME = PROPERTY_VALUE; //GetProperty - BEGIN

		public PROPERTY_TYPE PROPERTY_NAME
		{
			get
			{
				return this._PROPERTY_NAME;
			}
		} //GetProperty - END
	} //CompositeTypeFooter

	//CollectionType - BEGIN
	public class COLLECTION_TYPE : System.Collections.ObjectModel.ObservableCollection<ITEM_TYPE>
	{ 
	}
	//CollectionType - END
//ClrNamespaceFooter - BEGIN
#endif
}
//ClrNamespaceFooter - END